unit MemDump;

interface

uses SysUtils, Dialogs, StdCtrls;

//     RqSize ,  
//   RqAddr,     .
//  Font  RqReport - Courier New, Size = 10
procedure MemToHexAndCharDump (RqAddr   : pointer;
                               RqSize   : integer;
                               RqReport : TMemo);

implementation


//     
function ByteToHexStr (RqByte : byte): string;
const HexCharsArray : array[0..15] of char =
   ('0','1','2','3','4','5','6','7',
    '8','9','A','B','C','D','E','F');
begin
 //      Hex - 
 Result:= HexCharsArray[$0F and RqByte];
 //       
 Result:= HexCharsArray[($F0 and RqByte) shr 4] + Result;
end;

//       
//   RqSize ,    
// RqAddr.
function MemToHexStr (RqAddr : pointer; RqSize : integer): string;
var pt1 : ^byte;    //   
    Ind : integer;  //    
begin
  Result := '';
  if (RqAddr <> nil) and (RqSize > 0)
  then begin
    pt1 := RqAddr;
    try
      for Ind := 0 to RqSize -1 do
      begin
        Result := Result + ByteToHexStr(pt1^);
        //   
        pt1 := Ptr(Integer(pt1) + 1);
      end;
    except
       ShowMessage(' .  .');
    end;
  end;
end;

//     RqSize ,  
//   RqAddr,     .
procedure MemToHexAndCharDump (RqAddr   : pointer;
                               RqSize   : integer;
                               RqReport : TMemo);
const SLen    = 16;               //      
var   pt1     : ^byte;            //      
      BCount  : integer;          //     
      SCount  : integer;          //      
      WCount  : integer;          //      
      HStr    : string[80];       //   
      CStr    : string[80];       //   
begin

  if (RqAddr <> nil) and (RqSize > 0)
  then begin
    pt1     := RqAddr;
    BCount  := RqSize;
    RqReport.Lines.Add('Address    Code');
    try
      repeat //    
          HStr   := Format('%p',[pt1]) + ':' + '  '; //#09;
          CStr   := '';
          SCount := SLen;
          WCount := SizeOf(integer);
          repeat  //    
            HStr := HStr + ByteToHexStr(pt1^);
            WCount := WCount - 1;
            if WCount <= 0
            then begin
               HStr := HStr + ' ';
               WCount := SizeOf(integer);
            end;
            if pt1^ < $20  //   
            then CStr := CStr + '.'
            else CStr := CStr + Char(pt1^);
            //   
            pt1 := Ptr(Integer(pt1) + 1);
            BCount := BCount - 1;
            SCount := SCount - 1;
          until (SCount <=0);
          RqReport.Lines.Add(HStr + '  ' + CStr);
      until (BCount <= 0);
    except
       ShowMessage(' .  .');
    end;
  end;
end;



end.
 